//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ProcessCommand(char *ReceivedData, int ReceivedSize)
{
    int FlagLength = 0;
    int FlaggedLength = 0;
    char FlaggedData[MaxReceiveSize + 1];

    if((FlagLength = CompareFlagedString(ReceivedData, "::ImportTable:")))
    {
    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';
        
        strcpy(gsImportTable, FlaggedData);
        return COMMAND_RESULT_OK;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::FileCRC")))
    {
        sprintf(FlaggedData, "::FileCRC:%d", glDataCRC);
        SimpleClientSend(FlaggedData);
        return COMMAND_RESULT_OK;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::Statement:")))
    {
        char StatTemp[255];

    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        sprintf(StatTemp, "Exporting %s data.", gsImportTable);
        WriteLog(StatTemp);

        int SQL_Import_Result = ExportSQLResults(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, gsSQLDatabase, FlaggedData, gsImportTable, gsSQLExportTempFile);

        if(SQL_Import_Result == SQL_IMPORT_RESULT_ZEROROWS)
        {
            SimpleClientSend("::RequestNextStatement");
            return COMMAND_RESULT_OK;
        }
        else if (SQL_Import_Result == SQL_IMPORT_RESULT_OK){
            sprintf(FlaggedData, "::FileSize:%d", Get_FileSize(gsSQLExportTempFile));
            SimpleClientSend(FlaggedData);

            sprintf(FlaggedData, "::FileName:%s", gsImportTable);
            SimpleClientSend(FlaggedData);

            Sleep(1000);

            SendFileData(gsSQLExportTempFile);
            return COMMAND_RESULT_OK;
        }
        else if (SQL_Import_Result == SQL_IMPORT_RESULT_ERROR){
            // There was an error exporting the SQL data.
            // FIXME: What do we do now, Request the next statement or disconnect?
            SimpleClientSend("::RequestNextStatement");
            return COMMAND_RESULT_OK;
        }

        return COMMAND_RESULT_OK;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::LastImportSuccess")))
    {
        SQLBasics SQL;
        HSTMT UpdateHandle;
        char xStatement[255];

        if(!SQL.DBConnect(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, gsSQLDatabase))
        {
            printf("ImportSuccess DBConnect: Fail.\n");
            return COMMAND_RESULT_ERROR;
        }

        sprintf(xStatement, "UPDATE %s SET Portal_Dirty = 0 WHERE Portal_Dirty = 2", gsImportTable);
        if(!SQL.DBExecute(xStatement, &UpdateHandle))
        {
            DBCloseCursor(UpdateHandle);
            SQL.DBDisconnect();
            printf("ImportSuccess UPDATE DBexecute: Fail.\n");
            return COMMAND_RESULT_ERROR;
        }
        DBCloseCursor(UpdateHandle);

        SimpleClientSend("::RequestNextStatement");

        return COMMAND_RESULT_OK;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::LastImportFailed")))
    {
        WriteLog("SQL data failed to import on server side.");

        SQLBasics SQL;
        HSTMT UpdateHandle;
        char xStatement[255];

        if(!SQL.DBConnect(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, gsSQLDatabase))
        {
            printf("ImportFailed DBConnect: Fail.\n");
            return COMMAND_RESULT_ERROR;
        }

        sprintf(xStatement, "UPDATE %s SET Portal_Dirty = 1 WHERE Portal_Dirty = 2", gsImportTable);
        if(!SQL.DBExecute(xStatement, &UpdateHandle))
        {
            DBCloseCursor(UpdateHandle);
            SQL.DBDisconnect();
            printf("ImportFailed UPDATE DBexecute: Fail.\n");
            return COMMAND_RESULT_ERROR;
        }
        DBCloseCursor(UpdateHandle);

        SimpleClientSend("::RequestNextStatement");

        return COMMAND_RESULT_OK;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::DataCRCFailed")))
    {
        WriteLog("Data CRC failed.");
        // FIXME: What do we do now, Request the next statement or disconnect?
        SimpleClientSend("::RequestNextStatement");
        return COMMAND_RESULT_OK;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::Error:")))
    {
    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        WriteLog(FlaggedData);
        return COMMAND_RESULT_DISCONNECT;
    }
    else if(strcmp(ReceivedData, "::EndOfStatements") == 0)
    {
    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        WriteLog("End of statements.");
        return COMMAND_RESULT_DISCONNECT;
    }

    WriteLog("Received unknown command.");
	return COMMAND_RESULT_UNKNOWN;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

